<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\ExtraType\ExtraTypeRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ExtraTypeController extends Controller
{
    protected $extraTypeRepository;

    public function __construct()
    {
        $this->extraTypeRepository = app(ExtraTypeRepository::class);
    }

    public function index(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'search' => 'nullable',
            'branch_id' => 'required|numeric|exists:branches,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $categories = $this->extraTypeRepository->getWithFilter($request->all(), true);
        return response()->json(['data' => $categories]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'branch_id' => 'required|numeric|exists:branches,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $extraType = $this->extraTypeRepository->store($request->all());

        if ($extraType) {
            return response()->json(['data' => $extraType], 201);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);


    }

    public function show(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'extra_type_id' => 'required|numeric|exists:extra_types,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $extraType = $this->extraTypeRepository->show($request->extra_type_id);

        if (!$extraType) {
            return response()->json(['message' => 'هیچ موردی یافت نشد'], 404);
        }
        return response()->json(['data' => $extraType]);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'extra_type_id' => 'required|numeric|exists:extra_types,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }

        $extraType = $this->extraTypeRepository->update($request->extra_type_id, $request->all());
        if ($extraType) {
            return response()->json(['message' => 'عملیات با موفقیت انجام شد'], 200);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }

    public function destroy(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'extra_type_id' => 'required|numeric|exists:extra_types,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $extraType = $this->extraTypeRepository->destroy($request->extra_type_id);
        if (!$extraType) {
            return response()->json(['message' => 'عملیات با شکست مواجه شد'], 404);
        }
        return response()->json(['message' => 'با موفقیت حذف شد '], 200);
    }



}
