<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\Material\MaterialRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


class MaterialController extends Controller
{

    protected $materialRepository;

    public function __construct()
    {
        $this->materialRepository = app(MaterialRepository::class);
    }

    public function index(Request $request)
    {
        $categories = $this->materialRepository->getWithFilter($request->all(),true);
        return response()->json(['data'=>$categories]);
    }

    public function all(Request $request)
    {
        $categories = $this->materialRepository->getWithFilter($request->all());
        return response()->json(['data'=>$categories]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'unit_id' => 'required|numeric|exists:units,id',
            'category_id' => 'nullable|numeric|exists:categories,id',
            'price_per_unit' => 'required',
            'carbohydrate_per_unit' => 'required',
            'fat_per_unit' => 'required',
            'protein_per_unit' => 'required',
            'calorie_per_unit' => 'required|numeric',
            'image' => 'nullable|url',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $material = $this->materialRepository->store($request->all());

        if ($material) {
            return response()->json(['data' => $material], 201);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);


    }

    public function show(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'material_id' => 'required|numeric|exists:materials,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $material = $this->materialRepository->show($request->material_id);

        if (!$material) {
            return response()->json(['message' => 'هیچ موردی یافت نشد'], 404);
        }
        return response()->json(['data' => $material]);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'material_id' => 'required|numeric|exists:materials,id',
            'unit_id' => 'required|numeric|exists:units,id',
            'category_id' => 'nullable|numeric|exists:categories,id',
            'price_per_unit' => 'required',
            'carbohydrate_per_unit' => 'required',
            'fat_per_unit' => 'required',
            'protein_per_unit' => 'required',
            'calorie_per_unit' => 'required|numeric',
            'image' => 'nullable|url',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }

        $material = $this->materialRepository->update($request->material_id, $request->all());
        if ($material) {
            return response()->json(['message' => 'عملیات با موفقیت انجام شد'], 200);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }

    public function destroy(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'material_id' => 'required|numeric|exists:materials,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $material = $this->materialRepository->destroy($request->material_id);
        if (!$material) {
            return response()->json(['message' => 'عملیات با شکست مواجه شد'], 404);
        }
        return response()->json(['message' => 'مواد اولیه با موفقیت حذف شد '], 200);
    }

}
