<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\PercentOrderBranch\PercentOrderBranchRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PercentOrderBranchController extends Controller
{
    protected $percentOrderBranchRepository;

    public function __construct(PercentOrderBranchRepository $percentOrderBranchRepository)
    {
        $this->percentOrderBranchRepository = $percentOrderBranchRepository;
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'branch_id' => 'required|exists:branches,id',
            'percent' => 'required|numeric|between:0,100',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }

        $percentOrderBranch = $this->percentOrderBranchRepository->store([
            'branch_id' => $request->branch_id,
            'percent' => $request->percent,
        ]);

        return response()->json(['message' => 'درصد سفارش شعبه با موفقیت ثبت شد.', 'data' => $percentOrderBranch], 201);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'percent' => 'required|numeric|between:0,100',
            'branch_id' => 'required|numeric|exists:branches,id',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }

        $percentOrderBranch = $this->percentOrderBranchRepository->find($request->branch_id);

        if ($percentOrderBranch) {
            $percentOrderBranch = $this->percentOrderBranchRepository->update($request->branch_id, [
                'percent' => $request->percent,
            ]);
        } else {
            $percentOrderBranch = $this->percentOrderBranchRepository->store([
                'branch_id' => $request->branch_id,
                'percent' => $request->percent,
            ]);
        }

        return response()->json([
            'message' => 'درصد سفارش شعبه با موفقیت بروزرسانی شد.',
            'data' => $percentOrderBranch
        ], 200);
    }

    public function show(Request $request)
    {
        $percentOrderBranch = $this->percentOrderBranchRepository->find($request->branch_id);

        if (!$percentOrderBranch) {
            return response()->json(['error' => 'این درصد سفارش پیدا نشد.'], 404);
        }

        return response()->json(['data' => $percentOrderBranch], 200);
    }

    public function destroy($id)
    {
        $deleted = $this->percentOrderBranchRepository->delete($id);

        if (!$deleted) {
            return response()->json(['error' => 'این درصد سفارش پیدا نشد.'], 404);
        }

        return response()->json(['message' => 'درصد سفارش شعبه با موفقیت حذف شد.'], 200);
    }
}
