<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Setting;
use App\Repositories\Category\settingRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;

class SettingController extends Controller
{
    protected $settingRepository;

    public function __construct()
    {
        $this->settingRepository = app(\App\Repositories\Setting\SettingRepository::class);
    }

    public function index(Request $request)
    {
        $setting = $this->settingRepository->getWithFilter($request->all());
        return response()->json(['data' => $setting], 200);
    }

    public function storeOrUpdate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'items' => 'required|array',
            'items.*.name' => 'required',
            'items.*.value' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        foreach ($request->items as $key => $item) {
            if (isset($item['brand']))
                Setting::updateOrCreate(['name' => $item['name'], 'branch_id' => $item['branch_id'] ?? null],
                    ['value' => $item['value'], 'branch_id' => $item['branch_id'] ?? null]);
            else
                Setting::updateOrCreate(['name' => $item['name']],
                    ['value' => $item['value']]);
        }
        return response()->json(['message' => 'با موفقیت انجام شد']);
    }

    public function getWithNames(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'names' => 'required|array',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $data = Setting::whereIn('name', $request->names)->where('branch_id', $request->branch_id ?? null)->pluck('value', 'name')->toArray();
        return response()->json(['data' => $data]);
    }
}
