<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\Slider\SliderRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SliderController extends Controller
{
    protected $sliderRepository;

    public function __construct()
    {
        $this->sliderRepository = app(SliderRepository::class);
    }

    public function index(Request $request)
    {

        $categories = $this->sliderRepository->getWithFilter($request->all());
        return response()->json(['data'=>$categories], 200);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'image' => 'nullable|url',
            'link' => 'nullable|url',
            'branch_id' => 'nullable|numeric|exists:branches,id',
            'product_id' => 'nullable|numeric|exists:products,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $slider = $this->sliderRepository->store($request->all());
        return response()->json(['data' => $slider], 201);
    }

    public function show(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'slider_id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $slider = $this->sliderRepository->show($request->slider_id);
        if (!$slider) {
            return response()->json(['message' => ' یافت نشد'], 404);
        }
        return response()->json(['data' => $slider]);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'image' => 'nullable|url',
            'link' => 'nullable|url',
            'branch_id' => 'nullable|numeric|exists:branches,id',
            'product_id' => 'nullable|numeric|exists:products,id',
            'slider_id' => 'required|numeric|exists:sliders,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $slider = $this->sliderRepository->update($request->slider_id, $request->all());
        if ($slider) {
            return response()->json(['message' => 'عملیات با موفقیت انجام شد'], 200);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);    }

    public function destroy(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'slider_id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $slider = $this->sliderRepository->destroy($request->slider_id);
        if (!$slider) {
            return response()->json(['message' => 'عملیات با شکست مواجه شد'], 404);
        }
        return response()->json(['message' => ' موفقیت حذف شد '], 200);
    }
}
