<?php

namespace App\Http\Controllers\V1\Admin;

use App\Events\Ticket;
use App\Http\Controllers\Controller;
use App\Repositories\Ticket\TicketRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


class TicketController extends Controller
{
    protected $ticketRep;

    public function __construct()
    {
        $this->ticketRep = app(TicketRepository::class);
    }


    public function index(Request $request)
    {
        $tickets = $this->ticketRep->getTicketsByFilter($request->all());
        return response()->json(['data' => $tickets]);
    }


    public function getCategory()
    {
        $tickets = $this->ticketRep->getCategoryAdmin();
        return response()->json(['data' => $tickets]);
    }

    public function create(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'text' => 'required',
            'subject' => 'nullable',
            'category_id' => 'nullable|numeric|exists:ticket_categories,id',
            'file' => 'nullable|url',
            'parent_id' => 'nullable|numeric|exists:tickets,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $data = $request->all();
        $data['user_id'] = auth()->id();
        if (auth()->user()->role_id == 1)
            $data['status'] = "answered";

        $ticket = $this->ticketRep->store($data);

        if ($ticket) {
            if ($request->parent_id !== null and auth()->user()->role_id == 1)
                $this->ticketRep->updateStatus($request->parent_id, 'answered');

            event(new Ticket($ticket));

            return response()->json(['data' => $ticket], 201);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }

    public function show(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'ticket_id' => 'nullable|numeric|exists:tickets,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $ticket = $this->ticketRep->showTicketAdmin($request->ticket_id);
        if ($ticket) {
            return response()->json(['data' => $ticket], 200);
        }
        return response()->json(['message' => 'تیکتی یافت نشد'], 404);
    }


}
