<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use App\Models\User;
use App\Repositories\User\UserRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{

    protected $userRepository;

    public function __construct()
    {
        $this->userRepository = app(UserRepository::class);
    }

    public function index(Request $request)
    {

        $users = $this->userRepository->getWithFilter($request->all(), true);
        return response()->json(['data' => $users]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'family' => 'required',
            'mobile' => 'required|unique:users',
            'email' => 'nullable|email',
            'birth_date' => 'nullable|string',
            'role_id' => 'nullable'

        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $user = $this->userRepository->storeP($request->all());
        if ($user) {
            return response()->json(['data' => $user], 201);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);


    }

    public function show(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_id' => 'required|numeric|exists:users,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $user = $this->userRepository->show($request->user_id);
        if (!$user) {
            return response()->json(['message' => 'هیچ موردی یافت نشد'], 404);
        }
        return response()->json(['data' => $user]);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'family' => 'required',
            'mobile' => 'required',
            'email' => 'nullable|email',
            'birth_date' => 'nullable|string',
            'role_id' => 'nullable'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $user = $this->userRepository->update($request->user_id, $request->all());
        if ($user) {
            return response()->json(['message' => 'عملیات با موفقیت انجام شد'], 200);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }

    public function destroy(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_id' => 'required|numeric|exists:users,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $user = $this->userRepository->destroy($request->user_id);
        if (!$user) {
            return response()->json(['message' => 'عملیات با شکست مواجه شد'], 404);
        }
        return response()->json(['message' => 'با موفقیت حذف شد '], 200);
    }


    public function loginAsBranch(Branch $branch)
    {
        if (\auth()->user()->role_id != 7 && \auth()->user()->role_id != 1) {
            return response()->json(['data' => [], 'status' => 403, 'message' => 'شما دسترسی برای ورود ندارید'], 403);
        }

        try {
            $user = User::where('role_id', 3)->where('target_role_id', $branch->id)->first();
            if (!$user) {
                return response()->json(['data' => [], 'status' => 404, 'message' => 'کاربر پیدا نشد.'], 404);
            }

            $token = $user->createToken('Authenticate')->accessToken;

            return response()->json(['data' => [
                'token' => $token,
                'user' => $user
            ], 'status' => 200, 'message' => '']);
        } catch (\Exception $exception) {
            Log::info($exception);
            return response()->json(['data' => [], 'status' => 500, 'message' => $exception->getMessage()], 500);
        }
    }

    public function getUserByBranchId(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'branch_id' => 'required|numeric|exists:branches,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $users = $this->userRepository->getUserByBranchId($request->branch_id);
        if (!$users) {
            return response()->json(['message' => 'هیچ موردی یافت نشد'], 404);
        }
        return response()->json(['data' => $users]);
    }
}
