<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Repositories\BankAccount\BankAccountRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class BankAccountController extends Controller
{
    protected $bankAccountRepository;

    public function __construct()
    {
        $this->bankAccountRepository = app(BankAccountRepository::class);
    }

    public function index(Request $request)
    {

        $data = $this->bankAccountRepository->getByUser($request->all());
        return response()->json(['data' => $data], 200);
    }

    public function show(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'bank_account_id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $bankAccount = $this->bankAccountRepository->showC($request->bank_account_id);
        if (!$bankAccount) {
            return response()->json(['message' => ' یافت نشد'], 404);
        }
        return response()->json(['data' => $bankAccount]);
    }

    public function store(Request $request)
    {
        // فروشندگان دیگر نمی‌توانند حساب بانکی ایجاد کنند
        return response()->json(['error' => 'شما مجاز به ایجاد حساب بانکی نیستید. لطفا با ادمین تماس بگیرید.'], 403);
    }

    public function update(Request $request)
    {
        // فروشندگان دیگر نمی‌توانند حساب بانکی ویرایش کنند
        return response()->json(['error' => 'شما مجاز به ویرایش حساب بانکی نیستید. لطفا با ادمین تماس بگیرید.'], 403);
    }

    public function destroy(Request $request)
    {
        // فروشندگان دیگر نمی‌توانند حساب بانکی حذف کنند
        return response()->json(['error' => 'شما مجاز به حذف حساب بانکی نیستید. لطفا با ادمین تماس بگیرید.'], 403);
    }
}
