<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Repositories\User\UserRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CashBackController extends Controller
{
    protected $userRepository;

    public function __construct(UserRepository $userRepository)
    {
        $this->userRepository = $userRepository;
    }

    /**
     * User Cash Back Balances
     */
    public function getUserCashBackBalance()
    {
        try {
            $userId = Auth::id();
            $cashBackBalances = $this->userRepository->getUserCashBackBalances($userId);

            return response()->json([
                'status' => 200,
                'message' => 'موجودی cash back با موفقیت دریافت شد',
                'data' => $cashBackBalances
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => 'خطا در دریافت موجودی cash back',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * User Cash Back Balances By Branch
     */
    public function getUserCashBackBalanceByBranch(Request $request, $branchId)
    {
        try {
            $userId = Auth::id();
            $balance = $this->userRepository->getWalletUserInBranch($branchId, $userId);

            return response()->json([
                'status' => 200,
                'message' => 'موجودی cash back با موفقیت دریافت شد',
                'data' => [
                    'branch_id' => $branchId,
                    'user_id' => $userId,
                    'balance' => $balance,
                    'has_balance' => $balance > 0
                ]
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => 'خطا در دریافت موجودی cash back',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * User Cash Back Details
     */
    public function getUserCashBackDetails()
    {
        try {
            $userId = Auth::id();
            $cashBackDetails = $this->userRepository->getUserCashBackDetails($userId);

            return response()->json([
                'status' => 200,
                'message' => 'جزئیات cash back با موفقیت دریافت شد',
                'data' => $cashBackDetails
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 500,
                'message' => 'خطا در دریافت جزئیات cash back',
                'error' => $e->getMessage()
            ], 500);
        }
    }
}
