<?php

namespace App\Http\Controllers\V1\FileManager;

use App\Http\Controllers\Controller;
use App\Repositories\File\FileRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class FileController extends Controller
{
    protected $fileRepository;

    public function __construct(FileRepository $fileRepository)
    {
        $this->fileRepository = $fileRepository;
    }


    public function upload(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
        ]);

        try {
            $file = $request->file;
            $date = \Carbon\Carbon::now();
            $date = \Carbon\Carbon::parse($date)->format('d-m-Y');
            $ext = $file->getClientOriginalExtension();

            if (!auth()->check())
                $name = $date . '-' . Str::random(32);
            else {
                $user_id = auth()->id();
                $name = $user_id . $date . '-' . Str::random(32) . $user_id;
            }

            $file->storeAs('uploads', $name . '.' . $ext, 'public');

            $code = Str::random(40);

            $this->fileRepository->store([
                'user_id' => auth()->id(),
                'code' => $code,
                'path' => 'app/public/uploads/' . $name . '.' . $ext
            ]);

            Log::info(env('APP_URL'));
            return response()->json(['message' => 'File uploaded successfully', 'data' => env('APP_URL') . '/uploads/' . $name . '.' . $ext], 200);
        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage()], 400);
        }
    }


    public function find($code)
    {
        $file = $this->fileRepository->getFileWithCode($code);
//        dd(storage_path('app/public/'.$file->path));
        return response()->file(storage_path($file->path));
        if (file_exists($file->path)) {
        } else {
            return response()->json(['error' => 'File not found'], 404);
        }
    }
}
