<?php

    namespace App\Http\Controllers\V1;

    use App\Enums\OrderStatus;
    use App\Http\Controllers\Controller;
    use App\Models\ChargeWallet;
    use App\Models\Order;
    use App\Repositories\Address\AddressRepository;
    use App\Repositories\Branch\BranchRepository;
    use App\Repositories\Order\OrderRepository;
    use App\Services\PaymentService;
    use App\Services\WalletService;
    use GPBMetadata\Google\Api\Log;
    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Validator;
    use Illuminate\Support\Str;
    use Morilog\Jalali\Jalalian;

    class PaymentController extends Controller
    {
        protected $paymentService;
        protected $walletService;

        public function __construct(PaymentService $paymentService, walletService $walletService)
        {
            $this->paymentService = $paymentService;
            $this->walletService = $walletService;
        }

        public function setOrder(Request $request)
        {
            $validator = Validator::make($request->all(), [
                'delivery_time' => 'nullable',
                'coupon' => 'nullable',
            ]);

            if ($validator->fails())
                return response()->json(['error' => $validator->errors()->first()], 400);

            // دریافت سفارش ابتدایی برای گرفتن اطلاعات delivery و address
            $orderInitial = app(OrderRepository::class)->getLatestOrderUser();

            // محاسبه مجدد قیمت ارسال با توجه به area و delivery type
            $now = \Carbon\Carbon::now();
            $areaResult = null;

            if ($orderInitial->address_id && $orderInitial->branch_id) {
                $areaResult = app(\App\Services\AreaManagementService::class)->getActiveAreaForAddress(
                    $orderInitial->address_id,
                    $orderInitial->branch_id,
                    $now->format('l'),
                    $now->format('H:i:s'),
                    $orderInitial->address_order->lat ?? null,
                    $orderInitial->address_order->lng ?? null
                );
            }

            $order = app(OrderRepository::class)->getLatestOrderWithItems(
                null,
                $orderInitial->delivery_type_id,
                $areaResult,
                $orderInitial->address_id
            );

            if ($order['order']['delivery_type_id'] == null) {
                return response()->json(['status' => 400, 'message' => 'لطقا شیوه دریافت سفارش را انتخاب کنید ', 'data' => []], 400);
            }


            $deliveryTime = $request->delivery_time ?? $areaResult['data']?->delivery_time ?? null;
            if ($deliveryTime == null){
                date_default_timezone_set('Asia/Tehran');
                $deliveryTime = Jalalian::now()->format('Y/m/d H:i:s');
            }

//            $addressRep = app(AddressRepository::class)->checkAddress($deliveryTime, $order['order']['branch_id']);
//            if ($addressRep['data'] == null)
//                return response()->json(['error' => $addressRep['message']], $addressRep['status']);


            if ($order['price']['sumTotal'] == 0)
                return ['status' => 400, 'message' => 'سفارش نامعتبر است'];

            $orderDb = Order::where('id', $order['order']['id'])->where('order_status', OrderStatus::ORDERING)->first();

            if ($orderDb == null)
                return ['status' => 400, 'message' => 'سفارش نامعتبر است'];


            $branch = app(BranchRepository::class)->show($orderDb->branch_id);
            if ($branch == null)
                return response()->json(['status' => 400, 'error' => 'فروشنده یافت نشد', 'data' => []], 400);


            if ($branch->min_order != null and $order['price']['sumTotal'] < (int)$branch->min_order)
                return response()->json(['status' => 400, 'message' => 'حداقل مبلغ سفارش باید ' . $branch->min_order .' باشد' , 'data' => []], 400);

            if (isset($request->coupon) and $request->coupon != " " and $request->coupon != null)
                $discount = app(OrderRepository::class)->checkCoupon(['coupon' => $request->coupon])['data'] ?? ['discountPrice' => 0, 'coupon' => ['id' => 0]];
            else
                $discount = ['discountPrice' => 0, 'coupon' => ['id' => 0]];


            //cash-back
    //        sumTotal
    //        $pCashBack = 0;
    //        if ($order['order']->branch->cash_back_status == true and $order['order']->branch->cash_back_percent != 0) {
    //            $orderPrice = $order['price']['sumTotal'] - $discount["discountPrice"];
    //            $pCashBack = $orderPrice - PriceCalculation($orderPrice, $order['order']->branch->cash_back_max_price);
    //            if ($pCashBack > $order['order']->branch->cash_back_max_price)
    //                $pCashBack = $order['order']->branch->cash_back_max_price;
    //        }


            $orderDbCart = $orderDb->orderCart;
            $address = $orderDb->address_order;
            $orderDb->update(
                [
                    'payment_code' => Str::Random(40),
                    'order_price' => $order['price']['sumTotal'] - $discount["discountPrice"],
                    'delivery_price' => $order['price']['priceShippingOrder'],
                    'tax_price' => $order['price']['sumTax'],
                    'discount_price' => $discount["discountPrice"] ?? 0,
                    'coupon_id' => $discount["coupon"]["id"] ?? 0,
                    'delivery_time' => $deliveryTime,
                    'order_status' => OrderStatus::WATINGPAYMENT,
                    'description' => $request->description,
                    'carts' => $orderDbCart,
                    'address' => json_encode($address)
                ]);
            $orderDb = Order::where('id', $order['order']['id'])->first();
            return response()->json(['data' => $orderDb ?? null]);
        }

        public function payOrder(Request $request)
        {
            $code = $request->code;
            $gatewayId = $request->gateway_id;
            $useWallet = ($request->use_wallet==true) ? true : false;
            $setP = $this->paymentService->processPayment($code, $useWallet, $gatewayId);
            if ($setP['status'] == 200) {
                return redirect()->to($setP['data']['route']);
            }
            return redirect()->to(env('FrontUrl') . 'order?status=400&orderid=');
        }


        public function payConfirm(Request $request)
        {
            $check = $this->paymentService->confirmPayment($request->all());
            if ($check['status'] == 200) {
                return redirect()->to(env('FrontUrl') . 'order?status=200&orderid=' . $check['data']['orderId'] . '&=RefID' . $check['data']['paymentCodeGateway']);
            } else {
                return redirect()->to(env('FrontUrl') . 'order?status=400&orderid=' . $check['data']['orderId']);
            }
        }


        public function setChargeWallet(Request $request)
        {
            $validator = Validator::make($request->all(), [
                'amount' => 'required|numeric'
            ]);
            if ($validator->fails())
                return response()->json(['error' => $validator->errors()->first()], 400);
            $chargeWallet = new ChargeWallet();
            $chargeWallet->user_id = auth()->id();
            $chargeWallet->amount = $request->amount;
            $chargeWallet->code_pay = Str::random(40);
            $chargeWallet->save();
            return response()->json(['data' => $chargeWallet ?? null]);
        }

        public function chargeWallet(Request $request)
        {
            $validator = Validator::make($request->all(), [
                'code_pay' => 'required'
            ]);
            if ($validator->fails())
                return response()->json(['error' => $validator->errors()->first()], 400);

            $response = $this->walletService->processPayment($request->code_pay, 1);
            if ($response['status'] == 200) {
                return redirect()->to($response['data']['route']);
            }
            return redirect()->to(env('FrontUrl') . 'chargeResult?status=400');
        }

        public function chargeWalletConfirm(Request $request)
        {
            $check = $this->walletService->confirmPayment($request->all());
            if ($check['status'] == 200) {
                return redirect()->to(env('FrontUrl') . 'chargeResult?status=200&=RefID' . $check['data']['paymentCodeGateway']);
            } else {
                return redirect()->to(env('FrontUrl') . 'chargeResult?status=400');
            }
        }
    }
