<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Repositories\Branch\BranchRepository;
use App\Repositories\Category\CategoryRepository;
use App\Repositories\Product\ProductRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SearchController extends Controller
{
    public function searchProductAndBranch(Request $request)
    {
        $branches = app(BranchRepository::class)->search(['search' => $search ?? " "], true,['id','title','logo']);
        $products = app(ProductRepository::class)->search(['search' => $search ?? " "], true,['id','title','image']);
        return response()->json(['data' => ['branches' => $branches, 'product' => $products]]);
    }
}
