<?php

namespace App\Http\Controllers\V1;

use App\Enums\SliderType;
use App\Http\Controllers\Controller;
use App\Models\Area;
use App\Models\Slider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\Enum;

class SliderController extends Controller
{

    public function index(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'branche_id' => 'nullable',
            'type' => [new Enum(SliderType::class)],
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }

        $slider = Slider::with('product')->
        where(function ($query) use ($request) {
            if ($request->type != null and $request->type != " ") {
                $query->where('type', $request->type);
            }

            if ($request->branche_id != null and $request->branche_id != " ") {
                $query->where('branche_id', $request->branche_id);
            } else {
                $query->where('branche_id', 0);
            }
        })->get();

        return response()->json(['data' => $slider], 200);
    }
}
