<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Repositories\Setting\SettingRepository;
use App\Repositories\Transaction\TransactionRepository;
use App\Repositories\User\UserRepository;
use Illuminate\Http\Request;

class TransactionController extends controller
{


    protected $trasactionRep;

    public function __construct()
    {
        $this->trasactionRep = app(TransactionRepository::class);
    }

    public function userInventory()
    {
        $setting = app(SettingRepository::class)->getSettingWithNames(['systemMode', 'branchSingleModeId']);

        $userInventory = $this->trasactionRep->userInventory();
        if ($setting != null and isset($setting['systemMode']) and $setting['systemMode'] == "single") {
            $cashBack = app(UserRepository::class)->getWalletUserInBranch($setting['branchSingleModeId'], auth()->id());
            if ($cashBack != null)
                $userInventory = $cashBack + $userInventory;
        }

        return response()->json(['data' => $userInventory], 200);
    }

    public function userInventoryByUserId(Request $request)
    {
        $userId = $request->input('user_id');
        if (!$userId) {
            return response()->json(['error' => 'user_id is required'], 400);
        }
        $userInventory = $this->trasactionRep->userInventoryWithUser($userId);
        return response()->json(['data' => $userInventory, "statusCode" => 200], 200);
    }

    public function getTransactions(Request $request)
    {
        $transactions = app(UserRepository::class)->getTransactions();
        if (!$transactions) {
            return response()->json(['message' => 'عملیات با شکست مواجه شد'], 404);
        }
        return response()->json(['data' => $transactions], 200);
    }
}
