<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use App\Repositories\Area\AreaRepository;
use App\Repositories\Area\MaterialRepository;
use App\Repositories\Branch\BranchRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class AreaController extends Controller
{
    protected $areaRepository;

    public function __construct()
    {
        $this->areaRepository = app(AreaRepository::class);
    }

    public function index(Request $request)
    {
        $areas = $this->areaRepository->getWithFilter($request->all());
        return response()->json(['data' => $areas], 200);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'slug' => 'required|unique:areas',
            'parent_id' => 'nullable|numeric',
            'lat' => 'required|numeric|between:-90,90',
            'lng' => 'required|numeric|between:-180,180',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $area = $this->areaRepository->store($request->all());
        return response()->json(['data' => $area], 201);
    }

    public function show(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'area_id' => 'required|exists:areas,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $branch = $this->areaRepository->show($request->area_id);

        if (!$branch) {
            return response()->json(['message' => 'منطقه ای یافت نشد'], 404);
        }
        return response()->json(['data' => $branch]);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'slug' => 'required|' . Rule::unique('areas')->ignore($request->area_id),
            'parent_id' => 'nullable|numeric|exists:areas,id',
            'lat' => 'required|numeric|between:-90,90',
            'lng' => 'required|numeric|between:-180,180',
            'area_id' => 'required|numeric|exists:areas,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }


        $branch = $this->areaRepository->update($request->area_id, $request->all());
        if ($branch) {
            return response()->json(['message' => 'عملیات با موفقیت انجام شد'], 200);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }

    public function destroy(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'area_id' => 'required|exists:areas,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $branch = $this->areaRepository->destroy($request->area_id);
        if (!$branch) {
            return response()->json(['message' => 'عملیات با شکست مواجه شد'], 404);
        }
        return response()->json(['message' => 'منطقه با موفقیت حذف شد '], 200);
    }




}
