<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\BankAccount\BankAccountRepository;
use Illuminate\Http\Request;

class BankAccountController extends Controller
{
    protected $bankAccountRepository;

    public function __construct()
    {
        $this->bankAccountRepository = app(BankAccountRepository::class);
    }

    public function index(Request $request)
    {
        $data = $this->bankAccountRepository->getWithFilter($request->all(),true);
        return response()->json(['data' => $data], 200);
    }

}
