<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\Comment\CommentRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class CommentController extends Controller
{
    protected $commentRepository;

    public function __construct()
    {
        $this->commentRepository = app(CommentRepository::class);
    }

    public function index(Request $request)
    {
        $branches = $this->commentRepository->getWithFilter($request->all(), true);
        return response()->json(['data' => $branches]);
    }

    public function show(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'comment_id' => 'nullable|numeric|exists:comments,id',
        ]);
        if ($validator->fails())
            return response()->json(['error' => $validator->errors()->first()], 400);

        $branches = $this->commentRepository->showA($request->comment_id, true);

        return response()->json(['data' => $branches]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'text' => 'required',
            'parent_id' => 'nullable|numeric|exists:comments,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $data = $request->all();
        $data['user_id'] = auth()->id();
        $comment = $this->commentRepository->store($data);
        if ($comment) {
            return response()->json(['data' => $comment], 201);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }
}
