<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\Component\ComponentRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Validator;

class ComponentController extends Controller
{
    protected $componentRep;

    public function __construct()
    {
        $this->componentRep = app(ComponentRepository::class);

    }

    public function getListComponentAccess(Request $request)
    {
        $data = env('COMPONENT_ACCESS');
        return response()->json(['data' => explode(',', $data), 'message' => null, 'status' => 200]);
    }

    public function getFilterAndExtraInput($type)
    {
        $data = $this->componentRep->getFilterAndExtraInput($type);
        return response()->json(['data' => $data, 'message' => null, 'status' => 200]);
    }

    public function store(Request $request)
    {
        $data = $this->componentRep->storeCustom($request->all(null));
        return response()->json(['data' => $data, 'message' => null, 'status' => 200]);
    }

    public function list($slug = 'home', $type = 'main', Request $request)
    {
        $data = $this->componentRep->list($slug, $type, $request->all(null));
        return response()->json(['data' => $data, 'message' => null, 'status' => 200]);
    }

    public function update($id, Request $request)
    {
        $data = $this->componentRep->update($id, $request->all());
        if ($data)
            return response()->json(['data' => $data, 'message' => null, 'status' => 200]);
        return response()->json(['data' => [], 'message' => 'خطایی پیش آمده است', 'status' => 500]);
    }

    public function show($id)
    {
        $data = $this->componentRep->show($id);
        if ($data)
            return response()->json(['data' => $data, 'message' => null, 'status' => 200]);
        return response()->json(['data' => null, 'message' => 'خطایی پیش آمده است', 'status' => 500]);
    }

    public function destroy($id)
    {
        $data = $this->componentRep->destroy($id);
        if ($data)
            return response()->json(['data' => $data, 'message' => null, 'status' => 200]);
        return response()->json(['data' => [], 'message' => 'خطایی پیش آمده است', 'status' => 500]);
    }
}
