<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Models\DeliveryType;
use App\Repositories\DeliveryType\DeliveryTypeRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class DeliveryTypeController extends Controller
{
    public $deliveryTypeRepository;

    public function __construct()
    {
        $this->deliveryTypeRepository = app(DeliveryTypeRepository::class);
    }

    public function index(Request $request)
    {
        $data = $this->deliveryTypeRepository->getWithFilter($request->all());
        return response()->json(['data' => $data], 200);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'is_cost' => "required|boolean",
            'is_address' => "required|boolean",
            'message' => "required|max:255",
            'description_required' => 'required|boolean',
            'description_text' => 'required_if:description_required,1|max:255',
            'description_error_text' => 'required_if:description_required,1|max:255',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $area = $this->deliveryTypeRepository->store($request->all());
        return response()->json(['data' => $area], 201);
    }

    public function show(DeliveryType $deliveryType)
    {
        $deliveryType = $this->deliveryTypeRepository->show($deliveryType->id);
        if (!$deliveryType)
            return response()->json(['message' => 'موردی یافت نشد'], 404);
        return response()->json(['data' => $deliveryType]);
    }

    public function update(DeliveryType $deliveryType, Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'is_cost' => "required|boolean",
            'is_address' => "required|boolean",
            'message' => "required|max:255",
            'description_required' => 'required|boolean',
            'description_text' => 'required_if:description_required,1|max:255',
            'description_error_text' => 'required_if:description_required,1|max:255',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $deliveryType = $this->deliveryTypeRepository->update($deliveryType->id, $request->all());
        if ($deliveryType) {
            return response()->json(['message' => 'عملیات با موفقیت انجام شد']);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }

    public function destroy(deliveryType $deliveryType)
    {
        $deliveryType = $this->deliveryTypeRepository->destroy($deliveryType->id);
        if (!$deliveryType)
            return response()->json(['message' => 'عملیات با شکست مواجه شد'], 404);
        return response()->json(['message' => 'عملیات با موفقیت انجام شد']);
    }
}
