<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use App\Repositories\Area\AreaRepository;
use App\Repositories\Area\MaterialRepository;
use App\Repositories\ExportImport\ExportImportRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class ExportImportController extends Controller
{
    protected $exportImportRepository;

    public function __construct()
    {
        $this->exportImportRepository = app(ExportImportRepository::class);
    }

    public function listExport(Request $request)
    {
        $data = $this->exportImportRepository->getWithFilter(['type' => 'export']);
        return response()->json(['data' => $data], 200);
    }
}
