<?php

namespace App\Http\Controllers\V1\Admin;

use App\Enums\FavoriteType;
use App\Http\Controllers\Controller;
use App\Models\Area;
use App\Models\Favorite;
use App\Repositories\Area\AreaRepository;
use App\Repositories\Page\PageRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\Enum;

class PageController extends Controller
{
    public function index(Request $request)
    {
        $pages = app(PageRepository::class)->get();
        return response()->json(['data' => $pages]);
    }

    public function show(Request $request)
    {
        $pages = app(PageRepository::class)->show($request->page_id);
        return response()->json(['data' => $pages]);
    }


    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'slug' => 'required|unique:pages,slug',
            'text' => 'required'
        ]);
        if ($validator->fails())
            return response()->json(['error' => $validator->errors()->first()], 400);

        $page = app(PageRepository::class)->store($request->all());
        if ($page) {
            return response()->json(['data' => $page, 'message' => 'صفحه با موفقیت اضافه شد']);
        }
        return response()->json(['data' => null, 'message' => 'مشکلی پیش آمده است بعدا تلاش فرمایید'], 500);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'slug' => 'required|unique:pages,slug,'.$request->page_id,
            'text' => 'required',
            'page_id' => 'required|exists:pages,id'
        ]);
        if ($validator->fails())
            return response()->json(['error' => $validator->errors()->first()], 400);

        $page = app(PageRepository::class)->update($request->page_id, $request->all());
        if ($page) {
            return response()->json(['data' => $page, 'message' => 'صفحه با موفقیت اضافه شد']);
        }
        return response()->json(['data' => null, 'message' => 'مشکلی پیش آمده است بعدا تلاش فرمایید'], 500);
    }


    public function destroy(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'page_id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $page = app(PageRepository::class)->destroy($request->page_id);
        if ($page)
            return response()->json(['data' => null, 'message' => 'صفحه با موفقیت حذف شد'], 200);
        return response()->json(['data' => null, 'message' => 'مشکلی پیش آمده است بعدا تلاش فرمایید'], 500);
    }
}
