<?php

namespace App\Http\Controllers\V1\Admin;

use App\Enums\OrderStatus;
use App\Enums\SettlementRequestStatus;
use App\Enums\TransactionType;
use App\Http\Controllers\Controller;
use App\Repositories\Settlement\SettlementRepository;
use App\Repositories\Transaction\TransactionRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\Enum;

class SettlementController extends Controller
{
    protected $settlementRepository;

    public function __construct()
    {
        $this->settlementRepository = app(SettlementRepository::class);
    }

    public function index(Request $request)
    {
        $categories = $this->settlementRepository->getWithFilter($request->all(), true);
        return response()->json(['data' => $categories], 200);
    }

    public function getWalletRestaurant(Request $request)
    {
        $settlements = $this->settlementRepository->getWalletRestaurant($request->all(), true);
        return response()->json(['data' => $settlements], 200);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'amount' => 'required',
            'transaction_type' => ['nullable',new Enum(TransactionType::class)],
            'user_id' => 'required|numeric|exists:users,id',
            'description' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $settlement = app(TransactionRepository::class)->storeP($request->all());
        return response()->json(['data' => $settlement], 201);
    }

    public function destroy(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'settlement_id' => 'required|numeric|exists:settlement_requests,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $settlement = $this->settlementRepository->destroy($request->settlement_id);
        if (!$settlement) {
            return response()->json(['message' => 'عملیات با شکست مواجه شد'], 404);
        }
        return response()->json(['message' => 'دسته بندی با موفقیت حذف شد '], 200);
    }

    public function changeStatus(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'settlement_id' => 'required|numeric|exists:orders,id',
            'status' => [new Enum(SettlementRequestStatus::class)]
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $status = $this->settlementRepository->changeStatus($request->settlement_id, $request->status);
        if (!$status) {
            return response()->json(['message' => 'موجودی کیف پول کافی نبود'], 500);
        }
        return response()->json(['message' => 'با موفقیت انجام شد']);
    }

}
