<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\Transaction\TransactionRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class TransactionsController extends Controller
{

    protected $transactionRepository;

    public function __construct()
    {
        $this->transactionRepository = app(TransactionRepository::class);
    }

    public function index(Request $request)
    {
        $users = $this->transactionRepository->getWithFilter($request->all(), true);
        return response()->json(['data' => $users]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_id' => 'required|numeric|exists:users,id',
            'amount' => 'required',
            'description' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $user = $this->transactionRepository->store($request->all());
        if ($user) {
            return response()->json(['data' => $user], 201);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }
}
