<?php

namespace App\Http\Controllers\V1\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\Vendor\VendorRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class VendorController extends Controller
{
    protected $vendorRepository;

    public function __construct()
    {
        $this->vendorRepository = app(VendorRepository::class);
    }
    public function index(Request $request)
    {

        $vendors = $this->vendorRepository->getWithFilter($request->all(), true);
        return response()->json(['data' => $vendors]);
    }

    public function getRegisters(Request $request)
    {

        $vendors = $this->vendorRepository->getRegisters($request->all(), true);
        return response()->json(['data' => $vendors]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'user_id' => 'required|numeric|exists:users,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $product = $this->vendorRepository->storeP($request->all());
        if ($product) {
            return response()->json(['data' => $product], 201);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);


    }

    public function show(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'vendor_id' => 'required|numeric|exists:products,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $product = $this->vendorRepository->showWithRel($request->vendor_id);

        if (!$product) {
            return response()->json(['message' => 'هیچ موردی یافت نشد'], 404);
        }
        return response()->json(['data' => $product]);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'vendor_id' => 'required|numeric|exists:vendors,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $product = $this->vendorRepository->update($request->vendor_id, $request->all());
        if ($product) {
            return response()->json(['message' => 'عملیات با موفقیت انجام شد'], 200);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }

    public function destroy(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'vendor_id' => 'required|numeric|exists:products,id'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $vendor = $this->vendorRepository->destroy($request->vendor_id);
        if (!$vendor) {
            return response()->json(['message' => 'عملیات با شکست مواجه شد'], 404);
        }
        return response()->json(['message' => 'با موفقیت حذف شد '], 200);
    }

}
