<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Area;
use App\Repositories\Area\AreaRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class AreaController extends Controller
{
    public function getArea(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'area_id' => 'nullable|numeric|exists:areas,id',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }

        if ($request->parent_id and $request->parent_id !== null)
            $parentId = $request->parent_id;
        else
            $parentId = 0;

        $areas = app(AreaRepository::class)->getWithParentId($parentId);

        return response()->json(['data' => $areas]);

    }
}
