<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Repositories\BankAccount\BankAccountRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class BankAccountController extends Controller
{
    protected $bankAccountRepository;

    public function __construct()
    {
        $this->bankAccountRepository = app(BankAccountRepository::class);
    }

    public function index(Request $request)
    {

        $data = $this->bankAccountRepository->getByUser($request->all());
        return response()->json(['data' => $data], 200);
    }

    public function show(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'bank_account_id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $bankAccount = $this->bankAccountRepository->showC($request->bank_account_id);
        if (!$bankAccount) {
            return response()->json(['message' => ' یافت نشد'], 404);
        }
        return response()->json(['data' => $bankAccount]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'bank_name' => 'required',
            'account_holder_name' => 'required',
            'account_number' => 'required',
            'card_number' => 'required',
            'shaba_number' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $bankAccount = $this->bankAccountRepository->store($request->all());
        return response()->json(['data' => $bankAccount], 201);
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'bank_name' => 'required',
            'account_holder_name' => 'required',
            'account_number' => 'required',
            'card_number' => 'required',
            'shaba_number' => 'required',
            'bank_account_id' => 'required|numeric|exists:bank_accounts,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $bankAccount = $this->bankAccountRepository->updateC($request->bank_account_id, $request->all());
        if ($bankAccount) {
            return response()->json(['message' => 'عملیات با موفقیت انجام شد'], 200);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }



    public function destroy(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'bank_account_id' => 'required|numeric|exists:bank_accounts,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $bankAccount = $this->bankAccountRepository->destroyC($request->bank_account_id);
        if (!$bankAccount) {
            return response()->json(['message' => 'عملیات با شکست مواجه شد'], 404);
        }
        return response()->json(['message' => ' موفقیت حذف شد '], 200);
    }
}
