<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use App\Repositories\Branch\BranchRepository;
use App\Repositories\Delivery\DeliveryRepository;


class BranchController extends Controller
{
    protected $branchRep;

    public function __construct()
    {
        $this->branchRep = app(BranchRepository::class);
    }

    public function getActivityTime($branchId)
    {
        $times = $this->branchRep->getActivityTime($branchId);
        return response()->json(['data' => $times]);
    }

    public function show($id)
    {
        $branch = $this->branchRep->showC($id);
        if (!$branch)
            return response()->json(['message' => 'برنچی یافت نشد'], 404);
        return response()->json(['data' => $branch]);
    }

    public function getGallery($branchId)
    {
        $galleries = $this->branchRep->getGallery($branchId);
        return response()->json(['data' => $galleries]);
    }

    public function getNowStatus($branchId)
    {
        $active = $this->branchRep->getNowStatus($branchId);
        return response()->json(['data' => $active]);
    }


    public function perOrderTime($branchId)
    {
        $response = $this->branchRep->perOrderTime($branchId);
        return response()->json(['data' => $response['data'], 'status' => $response['status'], 'message' => $response['message']], $response['status']);
    }


    public function getActivityDay($branchId)
    {
        $active = $this->branchRep->getActivityDay($branchId);
        return response()->json(['data' => $active]);
    }

    public function getAllId()
    {
        return Branch::all()->pluck('id')->toArray() ?? [];
    }


    public function deliveryTypes($branchId)
    {
        $deliveryTypes = app(DeliveryRepository::class)->getDeliveryTypes($branchId);
        return response()->json($deliveryTypes, $deliveryTypes['status']);
    }


    public function sitemapList()
    {
        return response()->json(["status" => 200, "message" => "", "data" => ["branches" => $this->branchRep->sitemapList()]]);
    }


}
