<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Repositories\Category\CategoryRepository;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class CategoryController extends Controller
{
    public function getCategories(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'area_id' => 'nullable|numeric|exists:areas,id',
            'branch_id' => 'nullable|numeric|exists:vendors,id',
            'time' => 'nullable|date_format:H:i:s',
        ]);

        $time = $request->time;
        if ($time == null) {
            $time = Carbon::now()->format('H:i:s');
        }

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        if ($request->parent_id and $request->parent_id !== null)
            $parentId = $request->parent_id;
        else
            $parentId = 0;


        if (!$request->parent_id and $request->parent_id == null)
            $branchId = 0;
        else
            $branchId = $request->branch_id;
        $categories = app(CategoryRepository::class)->getWithFilter(['parent_id' => $parentId ?? "", 'branch_id' => $branchId ?? "", 'select' => ['id', 'title', 'img', 'parent_id', 'branch_id', 'start_serving', 'end_serving'], 'time' => $time]);
        return response()->json(['data' => $categories]);
    }
}
