<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Repositories\Comment\CommentRepository;

class CommentController extends Controller
{
    protected $commentRep;

    public function __construct()
    {
        $this->commentRep = app(CommentRepository::class);

    }

    public function getCommentProduct($productId)
    {
        $comments = $this->commentRep->getCommentProduct($productId);
        return response()->json(['data' => $comments]);
    }

    public function getCommentBranch($branchId)
    {
        $comments = $this->commentRep->getCommentBranch($branchId);
        return response()->json(['data' => $comments]);
    }

    public function getBranchRate($branchId)
    {
        $comments = $this->commentRep->getBranchRate($branchId);
        return response()->json(['data' => ['rate' => $comments], 'message' => "", "status" => 200]);
    }
}
