<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Repositories\Component\ComponentRepository;
use Illuminate\Http\Request;

class ComponentController extends Controller
{
    protected $componentRep;

    public function __construct()
    {
        $this->componentRep = app(ComponentRepository::class);

    }

    public function getWithCode($code, Request $request)
    {
        $comments = $this->componentRep->getFront($code, $request->all());
        return response()->json(['data' => $comments, 'message' => null, 'status' => 200]);
    }

    public function getListComponents($type, $slug = null)
    {
        $comments = $this->componentRep->getListComponentWithSlug($slug, $type);
        return response()->json(['data' => $comments, 'message' => null, 'status' => 200]);
    }

}
