<?php

namespace App\Http\Controllers\V1;

use App\Enums\FavoriteType;
use App\Http\Controllers\Controller;
use App\Models\Favorite;
use App\Repositories\Favorite\FavoriteRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\Enum;

class FavoriteController extends Controller
{
    protected $favoriteRep;
    function __construct(){
        $this->favoriteRep =app(FavoriteRepository::class);
    }
    public function getAllFavoriteIds()
    {
        $ids=$this->favoriteRep->getAllIds();
        return response()->json(['data' => $ids]);
    }

    public function checkStatus(Request $request)
    {
        $favorite=$this->favoriteRep->checkStatus($request->type,$request->target_id);
        return response()->json(['data' => $favorite]);
    }
    public function getWithType($type)
    {
        $ids=$this->favoriteRep->getWithType($type);
        return response()->json(['data' => $ids]);
    }
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'type' => [new Enum(FavoriteType::class)],
            'target_id' => 'required'
        ]);
        if ($validator->fails())
            return response()->json(['error' => $validator->errors()->first()], 400);

        $favorite=$this->favoriteRep->create(['type' => $request->type,'target_id' => $request->target_id]);
        if ($favorite instanceof Favorite) {
            return response()->json(['data'=>$favorite,'message'=>'با موفقیت به علاقه مندی شما اضافه شد']);
        }
        return response()->json(['data'=>null,'message'=>'مشکلی پیش آمده است بعدا تلاش فرمایید'], 500);
    }
    public function remove(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'type' => [new Enum(FavoriteType::class)],
            'target_id' => 'required'
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $favorite=$this->favoriteRep->remove(['type' => $request->type,'target_id' => $request->target_id]);
        if ($favorite)
            return response()->json(['data'=>null,'message'=>'با موفقیت از علاقه مندی های شما حذف شد'], 200);

        return response()->json(['data'=>null,'message'=>'مشکلی پیش آمده است بعدا تلاش فرمایید'], 500);
    }
}
