<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Area;
use App\Repositories\Area\AreaRepository;
use App\Repositories\Page\PageRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class PageController extends Controller
{
    public function index(Request $request)
    {
        $pages = app(PageRepository::class)->getListPage();
        return response()->json(['data' => $pages]);
    }
    public function show($slug)
    {
        $pages = app(PageRepository::class)->getWithSlug($slug);
        return response()->json(['data' => $pages]);
    }
}
