<?php

namespace App\Http\Controllers\V1;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Repositories\Branch\BranchRepository;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function index()
    {
        $settings = Setting::all();
        return response()->json($settings);
    }

    public function show($id)
    {
        $setting = Setting::find($id);

        if (!$setting) {
            return response()->json(['message' => 'Setting not found'], 404);
        }

        return response()->json($setting);
    }

    public function update(Request $request, $id)
    {
        $setting = Setting::find($id);

        if (!$setting) {
            return response()->json(['message' => 'Setting not found'], 404);
        }

        $setting->update($request->all());

        return response()->json($setting);
    }


    public function getSettingByName($name)
    {
        $setting = Setting::getSettingByName($name);

        if ($setting) {
            return response()->json($setting);
        } else {
            return response()->json(['message' => __('api.Setting not found')], 404);
        }
    }

    public function homeSetting()
    {
        $setting = Setting::where('name', 'Like', 'home_%')->get()->groupBy('name');
        if ($setting) {
            return response()->json($setting);
        } else {
            return response()->json(['message' => __('api.Setting not found')], 404);
        }
    }

    public function frontSetting()
    {
        $items = ["logo", "faveIcon", "logoPanel","backgroundPage", "title", "meta", "smDescription", "keywords", "scripts", "enamadCode"
            , "eata", "sorosh", "instagram", "telegram", "whatsapp", "headerTextSupport", "headerTelephoneSupport", "systemMode",
            "branchSingleModeId", "mainColor", "secondColor", "infoColor", "sidebarCart", "mapAddress", "titleAbout",
            "titleMenu", "linkRule", "google-site-verification", "baseHeader", "baseFooter", "contentHome", "contentSingleProduct",
            "contentSeller","landingType"];
        $setting = Setting::whereIn('name', $items)->where('branch_id', null)->pluck('value', 'name')->toArray();
        if ($setting) {
            return response()->json($setting);
        } else {
            return response()->json(['message' => __('api.Setting not found')], 404);
        }
    }

    public function getLogo()
    {
        $setting = Setting::where('name', "logo")->where('branch_id', null)->first()['value'] ?? [];
        if ($setting) {
            return response()->json($setting);
        } else {
            return response()->json(['message' => __('Setting not found')], 404);
        }
    }

    public function homeInfo()
    {
        $newRestaurants = app(BranchRepository::class)->getWithFilter([
            'selected' => [
                'id', 'title', 'address', 'lat', 'lng',
                'main_branch', 'category_id', 'area_id', 'vendor_id', 'logo',
                'cover', 'slug', 'rate', 'activities', 'meals'
            ],
            'sort_column' => 'id',
            'sort_type' => 'desc',
            'count_limit' => 10,
        ]);

        $popularRestaurants = app(BranchRepository::class)->getWithFilter([
            'selected' => [
                'id', 'title', 'address', 'lat', 'lng',
                'main_branch', 'category_id', 'area_id', 'vendor_id', 'logo',
                'cover', 'slug', 'rate', 'activities', 'meals'
            ],
            'sort_column' => 'rate',
            'sort_type' => 'desc',
            'count_limit' => 10,
        ]);

        $data = [
            [
                'title' => trans('api.latest sellers'),
                'restaurants' => $newRestaurants,
                'type' => 'restaurant'
            ],
            [
                'title' => trans('api.most popular sellers'),
                'restaurants' => $popularRestaurants,
                'type' => 'restaurant'
            ],
        ];
        $dataComponentPage = [
            "header" => [
                [
                    'type' => 'header1',
                    'data' => [],
                    'options' => []
                ]
            ],
            "headerMobile" => [
                [
                    'type' => 'headerMobile1',
                    'data' => [],
                    'options' => []
                ]
            ],
            "footer" => [
                [
                    'type' => 'footer1',
                    'data' => [],
                    'options' => []
                ]
            ],
            "footerMobile" => [
                [
                    'type' => 'footerMobil1',
                    'data' => [],
                    'options' => []
                ]
            ],
            "home" => [
                [
                    'type' => 'slider1',
                    'data' => [],
                    'options' => []
                ],

                [
                    'type' => 'category1',
                    'data' => [],
                    'options' => []
                ],
                [
                    'title' => trans('api.latest sellers'),
                    'restaurants' => $newRestaurants,
                    'type' => 'restaurant',
                    'options' => [
                        "category_id" => 1,
                        "more_text" => "مشاهده بیشتر",
                        "more_link" => "http://demo.limofood.ir/"
                    ]
                ],
            ],
            [
                'title' => trans('api.most popular sellers'),
                'restaurants' => $popularRestaurants,
                'type' => 'restaurant'
            ],
        ];


        return response()->json(['data' => $data, 'status' => 200, 'message' => null], 200);

    }
}
