<?php

namespace App\Http\Controllers\V1;

use App\Events\Ticket;
use App\Http\Controllers\Controller;
use App\Repositories\Ticket\TicketRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;


class TicketController extends Controller
{
    protected $ticketRep;

    public function __construct()
    {
        $this->ticketRep = app(TicketRepository::class);
    }


    public function index()
    {
        $tickets = $this->ticketRep->getTickets();
        return response()->json(['data' => $tickets]);
    }

    public function create(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'text' => 'required',
            'subject' => 'required',
            'category_id' => 'required|numeric|exists:ticket_categories,id',
            'file' => 'nullable|url',
            'parent_id' => 'nullable|numeric|exists:tickets,id',
        ]);
        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first()], 400);
        }
        $ticket = $this->ticketRep->store($request->all());
        if ($ticket) {
            if ($request->parent_id !== null)
                $this->ticketRep->updateStatus($request->parent_id, 'waiting_answer');


            event(new Ticket($ticket));
            return response()->json(['data' => $ticket], 201);
        }
        return response()->json(['message' => 'عملیات با شکست مواجه شد'], 400);
    }

    public function show(Request $request, $id)
    {
        $ticket = $this->ticketRep->showTicket($id);
        if ($ticket) {
            return response()->json(['data' => $ticket], 201);
        }
        return response()->json(['message' => 'تیکتی یافت نشد'], 404);
    }

    public function getCategory()
    {
        $tickets = $this->ticketRep->getCategory();
        return response()->json(['data' => $tickets]);
    }
}
