<?php

namespace App\Http\Middleware;

use App\Models\Branch;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Symfony\Component\HttpFoundation\Response;

class CheckAccess
{
    public function handle(Request $request, Closure $next): Response
    {
        $user = auth()->user();
        if ($user->role_id == 0)
            return response()->json(['message' => 'شما دسترسی به این بخش ندارید'], 403);
        //route
        $route = $request->route();
        if (!$route)
            return response()->json(['message' => 'شما دسترسی به این بخش ندارید'], 403);


        $configRouteAccessList = config('setting.RolePerm')[$user->role_id] ?? [];

        $routeName = $request->route()->getName();

        if (!in_array($routeName, array_keys($configRouteAccessList))) {
            return response()->json(['message' => 'شما دسترسی به این بخش ندارید'], 403);
        }

        $data = $request->all();


        if (isset($configRouteAccessList[$routeName]['vendor_id']) and $configRouteAccessList[$routeName]['vendor_id'] == "setFromToken") {
            $data['vendor_id'] = auth()->user()->target_role_id;
        }

        if (isset($configRouteAccessList[$routeName]['user_id']) and $configRouteAccessList[$routeName]['user_id'] == "setFromToken") {
            $data['user_id'] = auth()->id();
        }

        if (isset($configRouteAccessList[$routeName]['driver_id']) and $configRouteAccessList[$routeName]['driver_id'] == "setFromToken") {
            $data['driver_id'] = auth()->id();
        }

        if (isset($configRouteAccessList[$routeName]['agent_id']) and $configRouteAccessList[$routeName]['agent_id'] == "setFromToken") {
            $data['agent_id'] = auth()->user()->target_role_id;
        }

        if (isset($configRouteAccessList[$routeName]['branch_id']) and $configRouteAccessList[$routeName]['branch_id'] == "SetFromTokenChild") {
            $ids = Branch::where('vendor_id', auth()->user()->target_role_id)->pluck('id')->toArray();
            if (!isset($data['branch_id']) || !in_array($data['branch_id'], $ids))
                return response()->json(['message' => 'شما دسترسی به این بخش ندارید'], 403);
        }

        if (isset($configRouteAccessList[$routeName]['branch_id']) and $configRouteAccessList[$routeName]['branch_id'] == "setFromToken") {
            $data['branch_id'] = auth()->user()->target_role_id;
        }

        foreach ($configRouteAccessList[$routeName] as $key => $item) {
            if ($key == "vendor_id" || $key == "branch_id")
                continue;
            else {
                if ($item === "checkAccessModel" and isset($data[$key])) {
                    if (isset($configRouteAccessList[$routeName]['branch_id']) and $configRouteAccessList[$routeName]['branch_id'] == "SetFromTokenChild") {
                        $ids = Branch::where('vendor_id', auth()->user()->target_role_id)->pluck('id')->toArray();
                        $class = app($configRouteAccessList[$routeName][$key . '_model']);
                        $class = $class->where('id', $data[$key])->whereIn('branch_id', $ids)->first() ?? null;
                        if ($class == null) {
                            return response()->json(['message' => 'شما دسترسی به این بخش ندارید'], 403);

                        }
                    }

                    if (isset($configRouteAccessList[$routeName]['branch_id']) and $configRouteAccessList[$routeName]['branch_id'] == "setFromToken") {
                        $class = app($configRouteAccessList[$routeName][$key . '_model']);
                        $class = $class->where('id', $data[$key])->where('branch_id', auth()->user()->target_role_id)->first();
                        if ($class == null) {
                            return response()->json(['message' => 'شما دسترسی به این بخش ندارید'], 403);

                        }
                    }
                }
            }
        }


        $request->replace($data);

        return $next($request);
    }
}
