<?php

namespace App\Http\Middleware;

use App\Models\Branch;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Symfony\Component\HttpFoundation\Response;

class CheckCartUserOrGust
{
    public function handle(Request $request, Closure $next): Response
    {
        Auth::shouldUse('api');
        if (Auth::check()) {
            $request->merge(['user_id' => Auth::id()]);
        } else {
            if (!$request->hasHeader('GuestToken') || $request->header('GuestToken') == null) {
                $guestToken = Str::random(50);
                $request->merge(['guest_token' => $guestToken]);
            } else {
                $guestToken = $request->header('GuestToken');
                $request->merge(['guest_token' => $guestToken]);
            }
        }

        return $next($request);
    }
}
