<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class AreaManagementRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'address_id' => 'nullable|numeric',
            'branch_id' => 'required|numeric|exists:branches,id',
            'lat' => 'nullable|numeric',
            'lng' => 'nullable|numeric',
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'branch_id.required' => 'شناسه شعبه الزامی است.',
            'branch_id.numeric' => 'شناسه شعبه باید عدد باشد.',
            'branch_id.exists' => 'شعبه انتخاب شده معتبر نیست.',
            'address_id.numeric' => 'شناسه آدرس باید عدد باشد.',
            'lat.numeric' => 'عرض جغرافیایی باید عدد باشد.',
            'lng.numeric' => 'طول جغرافیایی باید عدد باشد.',
        ];
    }
}
