<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\Rule;

class AreaSpecialConditionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        Log::info('Request data: ', $this->all());
        $rules = [
            'branch_ids' => 'required|array',
            'branch_ids.*' => 'required|integer|exists:branches,id',
            'area_ids' => 'required|array',
            'area_ids.*' => 'required|integer|exists:areas,id',
            'title' => 'nullable|string|max:255',
            'description' => 'nullable|string|max:1000',
            'start_time' => 'required|',
            'end_time' => 'required|after:start_time',
            'date' => 'required|string',
            'percent' => 'required|integer|min:0|max:100',
            'status' => 'nullable|string|in:active,inactive',
        ];

        return $rules;
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'branch_ids.required' => 'شناسه شعبه الزامی است',
            'branch_ids.array' => 'شناسه شعبه باید آرایه باشد',
            'branch_ids.*.required' => 'شناسه شعبه الزامی است',
            'branch_ids.*.integer' => 'شناسه شعبه باید عدد صحیح باشد',
            'branch_ids.*.exists' => 'شعبه انتخابی وجود ندارد',

            'area_ids.required' => 'شناسه منطقه الزامی است',
            'area_ids.array' => 'شناسه منطقه باید آرایه باشد',
            'area_ids.*.required' => 'شناسه منطقه الزامی است',
            'area_ids.*.integer' => 'شناسه منطقه باید عدد صحیح باشد',
            'area_ids.*.exists' => 'منطقه انتخابی وجود ندارد',

            'title.string' => 'عنوان باید متن باشد',
            'title.max' => 'عنوان نمی‌تواند بیشتر از 255 کاراکتر باشد',

            'description.string' => 'توضیحات باید متن باشد',
            'description.max' => 'توضیحات نمی‌تواند بیشتر از 1000 کاراکتر باشد',

            'start_time.required' => 'زمان شروع الزامی است',
            'start_time.date_format' => 'فرمت زمان شروع صحیح نیست (HH:MM)',

            'end_time.required' => 'زمان پایان الزامی است',
            'end_time.date_format' => 'فرمت زمان پایان صحیح نیست (HH:MM)',
            'end_time.after' => 'زمان پایان باید بعد از زمان شروع باشد',

            'date.required' => 'تاریخ الزامی است',
            'date.date' => 'فرمت تاریخ صحیح نیست',
            'date.after_or_equal' => 'تاریخ نمی‌تواند قبل از امروز باشد',

            'percent.required' => 'درصد الزامی است',
            'percent.integer' => 'درصد باید عدد صحیح باشد',
            'percent.min' => 'درصد نمی‌تواند کمتر از 0 باشد',
            'percent.max' => 'درصد نمی‌تواند بیشتر از 100 باشد',

            'status.string' => 'وضعیت باید متن باشد',
            'status.in' => 'وضعیت باید active یا inactive باشد',
        ];
    }

    /**
     * Get custom attributes for validator errors.
     */
    public function attributes(): array
    {
        return [
            'branch_ids' => 'شناسه شعبه‌ها',
            'area_ids' => 'شناسه مناطق',
            'title' => 'عنوان',
            'description' => 'توضیحات',
            'start_time' => 'زمان شروع',
            'end_time' => 'زمان پایان',
            'date' => 'تاریخ',
            'percent' => 'درصد',
            'status' => 'وضعیت',
        ];
    }

}
