<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Log;

class CustomerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        Log::info($this->all());
        $rules = [
            'name' => 'required|string|max:255',
            'family' => 'required|string|max:255',
            'mobile' => 'required|string|max:20',
            'email' => 'nullable|email|max:255',
            'address' => 'nullable|string',
            'status' => 'nullable',
        ];

        // // Add unique validation for mobile when updating
        // if ($this->isMethod('PUT') || $this->isMethod('PATCH')) {
        //     $customerId = $this->route('customer');
        //     $rules['mobile'] = 'required|string|max:20|unique:users,mobile,' . $customerId . ',id';
        // } else {
        //     $rules['mobile'] = 'required|string|max:20|unique:users,mobile';
        // }

        // // Add branch_id validation for creation
        if ($this->isMethod('POST')) {
            $rules['branch_id'] = 'required|exists:branches,id';
        }

        return $rules;
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'name.required' => 'نام الزامی است',
            'name.string' => 'نام باید متن باشد',
            'name.max' => 'نام نمی‌تواند بیشتر از 255 کاراکتر باشد',

            'family.required' => 'نام خانوادگی الزامی است',
            'family.string' => 'نام خانوادگی باید متن باشد',
            'family.max' => 'نام خانوادگی نمی‌تواند بیشتر از 255 کاراکتر باشد',

            'mobile.required' => 'شماره موبایل الزامی است',
            'mobile.string' => 'شماره موبایل باید متن باشد',
            'mobile.max' => 'شماره موبایل نمی‌تواند بیشتر از 20 کاراکتر باشد',
            'mobile.unique' => 'این شماره موبایل قبلاً ثبت شده است',

            'email.email' => 'ایمیل معتبر نیست',
            'email.max' => 'ایمیل نمی‌تواند بیشتر از 255 کاراکتر باشد',

            'address.string' => 'آدرس باید متن باشد',

            'branch_id.required' => 'شناسه شعبه الزامی است',
            'branch_id.exists' => 'شعبه انتخاب شده معتبر نیست',
        ];
    }

    /**
     * Get custom attributes for validator errors.
     */
    public function attributes(): array
    {
        return [
            'name' => 'نام',
            'family' => 'نام خانوادگی',
            'mobile' => 'شماره موبایل',
            'email' => 'ایمیل',
            'address' => 'آدرس',
            'branch_id' => 'شناسه شعبه',
            'status' => 'وضعیت',
        ];
    }
}
