<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserOrderStatsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'total_orders' => $this->resource['total_orders'],
            'delivered_orders' => $this->resource['delivered_orders'],
            'cancelled_orders' => $this->resource['cancelled_orders'],
            'total_spent' => $this->resource['total_spent'],
            'average_order_value' => $this->resource['average_order_value'],
            'last_order_date' => $this->resource['last_order_date'],
            'delivery_rate' => $this->resource['total_orders'] > 0
                ? round(($this->resource['delivered_orders'] / $this->resource['total_orders']) * 100, 2)
                : 0,
            'cancellation_rate' => $this->resource['total_orders'] > 0
                ? round(($this->resource['cancelled_orders'] / $this->resource['total_orders']) * 100, 2)
                : 0,
            'favorite_products' => $this->resource['favorite_products'],
        ];
    }
}
