<?php

namespace App\Jobs;

use App\Models\Order;
use App\Repositories\Print\PrintRepository;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;

class PreparePrintJobs implements ShouldQueue
{
    use Dispatchable, Queueable;

    public function __construct(public int $orderId) {}

    public function handle(PrintRepository $repo): void
    {
        $order = Order::with('items')->findOrFail($this->orderId);

        $map   = $repo->mapOrderItemsToPrinters($order);

        $payloadPath = null;

        $repo->createJobsForOrder($order, $map, $payloadPath);
    }
}
