<?php

namespace App\Jobs;

use App\Models\Order;
use App\Models\Variety;
use Illuminate\Bus\Queueable;
use Illuminate\Bus\Batchable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class ProcessDeleteOrderJob implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, Batchable;

    protected int $orderId;

    public function __construct(int $orderId)
    {
        $this->orderId = $orderId;
    }

    public function handle()
    {
        // Ensure the batch has not been canceled
        if ($this->batch() && $this->batch()->cancelled()) {
            return;
        }


        $order = Order::find($this->orderId);

        if (!$order) {
            return; // Order already deleted
        }

        foreach ($order->orderCart as $item) {
            $product = Variety::find($item->variety_id);
            if ($product) {
                $product->increment('count', $item->count);
            }
        }
        Log::info($order);
        $order->delete();
    }
}
