<?php

namespace App\Jobs;

use App\Repositories\SMS\SMSRepositoryInterface;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class SendInactiveProductsSms implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $inactiveCount;
    public $restaurantName;
    public $mobile;

    /**
     * Create a new job instance.
     */
    public function __construct($inactiveCount, $restaurantName, $mobile)
    {
        $this->inactiveCount = $inactiveCount;
        $this->restaurantName = $restaurantName;
        $this->mobile = $mobile;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        try {
            $smsRepository = app(SMSRepositoryInterface::class);
            $result = $smsRepository->sendSMSInactiveProducts(
                $this->inactiveCount,
                $this->restaurantName,
                $this->mobile
            );
            
            Log::info("SMS محصولات غیرفعال ارسال شد", [
                'inactive_count' => $this->inactiveCount,
                'restaurant_name' => $this->restaurantName,
                'mobile' => $this->mobile,
                'result' => $result
            ]);
        } catch (\Exception $e) {
            Log::error("خطا در ارسال SMS محصولات غیرفعال: " . $e->getMessage(), [
                'inactive_count' => $this->inactiveCount,
                'restaurant_name' => $this->restaurantName,
                'mobile' => $this->mobile
            ]);
            throw $e;
        }
    }
}





