<?php

namespace App\Jobs;

use App\Repositories\SMS\SMSRepositoryInterface;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class SendOrderDelayApprovalSms implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $orderId;
    protected $customerName;
    protected $orderAmount;
    protected $restaurantName;
    protected $mobile;

    public function __construct($orderId, $customerName, $orderAmount, $restaurantName, $mobile)
    {
        $this->orderId = $orderId;
        $this->customerName = $customerName;
        $this->orderAmount = $orderAmount;
        $this->restaurantName = $restaurantName;
        $this->mobile = $mobile;
    }

    /**
     * Execute the job.
     */
    public function handle(SMSRepositoryInterface $SMSRepository): void
    {
        try {
            $result = $SMSRepository->sendSMSOrderDelayApproval(
                $this->orderId,
                $this->customerName,
                $this->orderAmount,
                $this->restaurantName,
                $this->mobile
            );

            Log::info("SMS sent for order delay approval - Order ID: {$this->orderId}, Mobile: {$this->mobile}", $result);
        } catch (\Exception $e) {
            Log::error("Failed to send SMS for order delay approval - Order ID: {$this->orderId}, Error: " . $e->getMessage());
        }
    }
}
