<?php

namespace App\Jobs;

use App\Repositories\SMS\SMSRepositoryInterface;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Log;

class SendOrderDelayDeliverySms implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $orderId;
    protected $customerName;
    protected $mobile;

    public function __construct($orderId, $customerName, $mobile)
    {
        $this->orderId = $orderId;
        $this->customerName = $customerName;
        $this->mobile = $mobile;
    }

    /**
     * Execute the job.
     */
    public function handle(SMSRepositoryInterface $SMSRepository): void
    {
        try {
            $result = $SMSRepository->sendSMSOrderDelayDelivery(
                $this->orderId,
                $this->customerName,
                $this->mobile
            );

            Log::info("SMS sent for order delay delivery - Order ID: {$this->orderId}, Mobile: {$this->mobile}", $result);
        } catch (\Exception $e) {
            Log::error("Failed to send SMS for order delay delivery - Order ID: {$this->orderId}, Error: " . $e->getMessage());
        }
    }
}
