<?php

namespace App\Jobs;

use App\Repositories\SMS\SMSRepositoryInterface;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Melipayamak\MelipayamakApi;


class SendSms implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;


    protected $params = [];

    protected $text = "";
    protected $bodyId = 0;

    protected $mobile;

    protected $SMSRepository;


    public function __construct($params, $bodyId, $mobile)
    {
        $this->params = $params;
        $this->mobile = $mobile;
        $this->bodyId = $bodyId;
    }

    /**
     * Execute the job.
     */
    public function handle(SMSRepositoryInterface $SMSRepository): void
    {
        $SMSRepository->sendSMS($this->params, $this->bodyId, $this->mobile);
    }
}
