<?php

namespace App\Listeners;

use App\Events\OrderSaved;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class OrderSaveSendSms
{
    public function handle(OrderSaved $event)
    {
        $order = $event->order;

        // Add logic to send SMS to the driver
        $this->sendSMSToDriver($order);

        // Add logic to send SMS to the restaurant
        $this->sendSMSToRestaurant($order);

        // Add logic to send SMS to the user
        $this->sendSMSToUser($order);
    }

    private function sendSMSToDriver($order)
    {
        // Implement the logic to send SMS to the driver
    }

    private function sendSMSToRestaurant($order)
    {
        // Implement the logic to send SMS to the restaurant
    }

    private function sendSMSToUser($order)
    {
        // Implement the logic to send SMS to the user
    }
}
