<?php

namespace App\Listeners;

use App\Events\ticketChangeStatus;
use App\Events\ticketSaved;
use App\Events\Ticket;
use App\Models\User;
use App\Repositories\SMS\SMSRepositoryInterface;
use App\Repositories\User\UserRepository;
use Illuminate\Support\Facades\Log;

class TicketStatusSendSms
{
    protected $SMSRepository;

    public function __construct(SMSRepositoryInterface$SMSRepository)
    {
        $this->SMSRepository=$SMSRepository;
    }
    public function handle(Ticket $event)
    {
        $ticket = $event->ticket;
        $user = app(UserRepository::class)->show($ticket->user_id);
        $this->sendSMS($ticket, $user);
    }

    private function sendSMS($ticket, $user)
    {

        $ticketId = ($ticket->parent_id == 0) ? $ticket->id : $ticket->parent_id;

        if ($ticket->status == "answered") {
            $result = $this->SMSRepository->sendSMSTicketAnswered('#' . $ticketId, $user->mobile);

            Log::info('sms ' . json_encode($result));
        }


        if ($ticket->status == "waiting_answer") {
            $mobiles = User::where('role_id', 1)->get()->pluck('mobile')->toArray();
            $result = $this->SMSRepository->sendSMSWaitingAnswer('#' . $ticketId, $mobiles);
            Log::info('sms ' . json_encode($result));
        }

    }
}
