<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Area extends Model
{
    use HasFactory;
    protected $guarded=['id'];
    use SoftDeletes;

    protected $casts = [
        'coordinates' => 'array',
    ];

    public function parent()
    {
        return $this->belongsTo(self::class, 'parent_id', 'id');
    }

    public function hasManagement($branchId = null)
    {
        $query = $this->hasOne(AreaManagement::class, 'area_id', 'id');

        if ($branchId) {
            $query->where('branch_id', $branchId);
        }

        return $query;
    }

    /**
     * Check if area has management for specific branch
     */
    public function hasManagementForBranch($branchId)
    {
        return $this->hasManagement($branchId)->exists();
    }
}
