<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AreaManagement extends Model
{
    use HasFactory;

    protected $casts = [
        'shipping_methods' => 'array',
        'order_amounts' => 'array',
        'free_delivery' => 'boolean',
        'status' => 'boolean'
    ];
    protected $guarded = ['id'];

    public function area()
    {
        return $this->belongsTo(Area::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function deliveryType()
    {
        return $this->belongsTo(DeliveryType::class);
    }
}
